\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{vetorstyle}[2020/12/10]
\LoadClass[onecolumn,10pt]{article}

\RequirePackage{ifthen}
\RequirePackage[utf8]{inputenc}
\RequirePackage[T1]{fontenc}
\RequirePackage{csquotes}
\RequirePackage{hyperref}
\RequirePackage{stix2}

%----------------------------------------------------------------------
%	CAPTION	
%----------------------------------------------------------------------

\RequirePackage{caption}

%----------------------------------------------------------------------
%	COLORS	
%----------------------------------------------------------------------

\RequirePackage{xcolor}
\definecolor{lightgray}{RGB}{94,94,94}

%----------------------------------------------------------------------
%	IMAGES
%----------------------------------------------------------------------

\RequirePackage{graphicx}

%----------------------------------------------------------------------
%	TABLES
%----------------------------------------------------------------------

\RequirePackage{tabu}
\RequirePackage{multirow}

%----------------------------------------------------------------------
%	ALGORITHMS
%----------------------------------------------------------------------

\RequirePackage{capt-of}

\RequirePackage[plain,format=hang,singlelinecheck=false]{algorithm}
\RequirePackage{algpseudocode}

\let\Algorithm\algorithm
\renewcommand\algorithm[1][]{\Algorithm[#1]\setstretch{1.1}}

\newcommand{\algcaption}[1]{\captionof{algorithm}{#1}}

%----------------------------------------------------------------------
%	MATH ENVIRONMENT
%----------------------------------------------------------------------

\RequirePackage{amsmath}
\RequirePackage{mathtools}

\renewcommand{\vec}{\boldsymbol}
\renewcommand{\d}{\mathrm{d}}
\newcommand{\R}{\mathrm{I\!R}}

%----------------------------------------------------------------------
%	BIBLIOGRAPHY AND LANGUAGE
%----------------------------------------------------------------------

% \RequirePackage[num,abnt-doi=link,abnt-emphasize=bf]{abntex2cite}
% \citebrackets[]

\RequirePackage[brazilian]{babel}

\bibliographystyle{./IEEEtran.bst}

\renewcommand{\@biblabel}[1]{[#1]\;}

\newcommand{\source}[1]{\vspace*{-2em}\caption*{Fonte: {#1}}\vspace*{-2em}}
\renewcommand{\ALG@name}{Algoritmo}

%----------------------------------------------------------------------
%	SPACING	
%----------------------------------------------------------------------

\setlength{\abovecaptionskip}{15pt}
\setlength{\belowcaptionskip}{15pt}
\setlength{\tabulinesep}{1.2mm}

%----------------------------------------------------------------------
%	MARGINS	
%----------------------------------------------------------------------

\RequirePackage[left=2cm,%
right=2cm,%
top=2.25cm,%
bottom=2.25cm,%
headheight=0cm,%
a4paper,
heightrounded]{geometry}%

%----------------------------------------------------------------------
%	INFORMATION VARIABLES
%----------------------------------------------------------------------  

\newcommand{\PaperTitle}[1]{\def\@PaperTitle{#1}}
\newcommand{\PaperTitlePortuguese}[1]{\def\@PaperTitlePortuguese{#1}}
\newcommand{\ShortTitle}[1]{\def\@ShortTitle{#1}}
\newcommand{\Archive}[1]{\def\@Archive{#1}}
\newcommand{\Authors}[1]{\def\@Authors{#1}}
\newcommand{\ShortAuthors}[1]{\def\@ShortAuthors{#1}}
\newcommand{\JournalName}[1]{\def\@JournalName{#1}}
\newcommand{\JournalInfo}[1]{\def\@JournalInfo{#1}}
\newcommand{\Abstract}[1]{\def\@Abstract{#1}}
\newcommand{\AbstractPortuguese}[1]{\def\@AbstractPortuguese{#1}}
\newcommand{\Keywords}[1]{\def\@Keywords{#1}}
\newcommand{\KeywordsPort}[1]{\def\@KeywordsPort{#1}}
\newcommand{\CorrAuthor}[1]{\def\@CorrAuthor{#1}}

%----------------------------------------------------------------------
%	PAGE HEADER AND FOOTER
%----------------------------------------------------------------------

\RequirePackage[pagestyles]{titlesec}
\newpagestyle{mystyle}{
  \setfoot{}{\small\color{lightgray}\@JournalName, Rio Grande, \@JournalInfo}{\small\color{lightgray}\thepage}}
  
\pagestyle{mystyle}
\sethead{\@ShortTitle}{}{\@ShortAuthors}\headrule

%----------------------------------------------------------------------
%	CORRESPONDING AUTHOR
%----------------------------------------------------------------------

\newcommand{\corr}{$ ^{\text{,}\dagger} $}

%----------------------------------------------------------------------
%	TITLE PAGE
%----------------------------------------------------------------------  

\RequirePackage{ragged2e}

\newcommand{\maketitlepage}{%
\onecolumn{%
\thispagestyle{mystyle}

%%% Logo
{\vspace*{-3em}\hfill\includegraphics[width=3cm]{logo_vetor}}%
\vskip20pt%

%%% Titulo
{\raggedright\bfseries\fontsize{20}{25}\selectfont \@PaperTitlePortuguese\par}%
{\raggedright\bfseries\fontsize{14}{20}\selectfont \@PaperTitle\par}%

%%% Autores
\vskip10pt%
{\raggedright\fontsize{12}{16}\selectfont  \@Authors\par}%
\vskip15pt%
\begingroup%
\raggedright\normalsize\textit{\@affiliation}\par%

%%% Autor correspondente

\raggedright{$ ^{\dagger} $}{\bfseries\normalsize Autor correspondente:} \normalsize \@CorrAuthor
\endgroup%%
\vskip15pt%

%%% Resumo
\raggedright\textbf{Resumo}\\[4pt]\begin{justify}\@AbstractPortuguese\end{justify}%
\raggedright\textbf{Palavras-chave}\\[4pt]\ignorespaces\@KeywordsPort\\[15pt]%
\raggedright\textbf{Abstract}\\[4pt]\begin{justify}\@Abstract\end{justify}%
\raggedright\textbf{Keywords}\\[4pt]\ignorespaces\@Keywords%
\vskip15pt%
}%
}

%----------------------------------------------------------------------
%	KEYWORDS
%----------------------------------------------------------------------

\newcommand{\keywordname}{Keywords}
\newcommand{\sep}{$\!\!\enspace\bullet\enspace$}

%----------------------------------------------------------------------
%	MULTIPLE AUTHOR SET
%----------------------------------------------------------------------  
  
\newcount\@authcnt
\newcount\@tmpcnt\@tmpcnt\z@

\def\@affiliation{%
  \ifnum\@tmpcnt<\@authcnt
   \global\advance\@tmpcnt1
    \raggedright \csname @auth\romannumeral\the\@tmpcnt\endcsname\hfill\\%
   \let\next\@affiliation \vskip1pt
  \else
   \let\next\relax
  \fi
\next}
	 
\newcommand{\affiliation}[1]{%
    \global\advance\@authcnt1
    \expandafter\gdef\csname @auth\romannumeral\the\@authcnt\endcsname
    {#1}}